#include <stdio.h>
#include <time.h>
#include <sys/time.h>

static FILE *fp_trace;

void
__attribute__ ((constructor))
trace_begin (void)
{
 fp_trace = fopen("trace.out", "w");
}

void
__attribute__ ((destructor))
trace_end (void)
{
 if(fp_trace != NULL) {
 fclose(fp_trace);
 }
}

void
__cyg_profile_func_enter (void *func,  void *caller)
{
 if(fp_trace != NULL) {
  struct timespec ts;
  clock_gettime(CLOCK_REALTIME, &ts);

  fprintf(fp_trace, "e %p %p %ld\n", func, caller, ts.tv_nsec );
 }
}

void
__cyg_profile_func_exit (void *func, void *caller)
{
 if(fp_trace != NULL) {
  struct timespec ts;
  clock_gettime(CLOCK_REALTIME, &ts);

  fprintf(fp_trace, "x %p %p %ld\n", func, caller, ts.tv_nsec );
 }
}

