#!/bin/sh
if test ! -f "$1"
then
 echo "Error: executable $1 does not exist."
 exit 1
fi

if test ! -f "$2"
then
 echo "Error: trace log $2 does not exist."
 exit 1
fi

EXECUTABLE="$1"
TRACELOG="$2"

if [ ! -z "$3" ];
then
 DEMANGLE="-C"
else
 DEMANGLE=""
fi

while read LINETYPE FADDR CADDR CTIME; do
 FNAME="$(addr2line ${DEMANGLE} -f -e ${EXECUTABLE} ${FADDR}|head -1)"
 #CDATE="$(date -Iseconds -d @${CTIME})"
 CDATE=${CTIME}

 if test "${LINETYPE}" = "e"
 then
  CNAME="$(addr2line ${DEMANGLE} -f -e ${EXECUTABLE} ${CADDR}|head -1)"
  CLINE="$(addr2line ${DEMANGLE} -s -e ${EXECUTABLE} ${CADDR})"
  echo "Enter\t${FNAME}\t${CDATE}\t${CNAME}\t${CLINE}"
 fi
 
 if test "${LINETYPE}" = "x"
 then
  echo "Exit\t${FNAME}\t${CDATE}"
 fi
done < "${TRACELOG}"

